/** von aborix **/
/** von hier:https://www.camp-firefox.de/forum/thema/129425-lesezeichenordner-ohne-klicken-%C3%B6ffnen/?pageNo=3 **/


(function() {

  if (!window.gBrowser)
    return;

  let itemToClose = null;
  let timeoutEnter, timeoutLeave;
  let placesContext = document.getElementById('placesContext');

  placesContext.addEventListener('popuphidden', function() {
    if (itemToClose) {
      itemToClose.open = false;
      itemToClose = null;
    };
  });

  function onMouseenter(event) {
    clearTimeout(timeoutLeave);
    timeoutEnter = setTimeout(function() {
      itemToClose = null;
      if (placesContext._view && !placesContext._view._openedMenuButton) {
        placesContext.hidePopup();
      };
      event.target.open = true;
    }, 100);
  };

  function onMouseleave(event) {
    clearTimeout(timeoutEnter);
    timeoutLeave = setTimeout(function() {
      if (placesContext.state == 'closed') {
        event.target.open = false;
        itemToClose = null;
      } else {
        itemToClose = event.target;
      };
    }, 100);
  };

  function addListeners() {
    let items = document.querySelectorAll('#PlacesToolbarItems > toolbarbutton[type="menu"]');
    for (let item of items) {
      item.addEventListener('mouseenter', onMouseenter);
      item.addEventListener('mouseleave', onMouseleave);
    };
  };

  setTimeout(addListeners, 500);

  window.addEventListener('aftercustomization', function() {
    setTimeout(addListeners, 100);
  });

})();